/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.common.shop.type;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.KnownServerRegistries;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryType;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public class ShopAdvancementEntryType
extends AbstractShopEntryType {
    public ResourceLocation advancement;
    public ItemStack iconPath = Items.f_42405_.m_7968_();

    public ShopAdvancementEntryType(ResourceLocation advancement) {
        this.advancement = advancement;
    }

    @Override
    public void buy(Player player, int countBuy, AbstractShopEntry entry) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            long playerMoney = SDMShopR.getMoney(player);
            long needMoney = entry.entryPrice;
            Advancement a = serverPlayer.f_8924_.m_129889_().m_136041_(this.advancement);
            if (a != null) {
                for (String s : a.m_138325_().keySet()) {
                    serverPlayer.m_8960_().m_135988_(a, s);
                }
                SDMShopR.setMoney(player, playerMoney - needMoney);
            }
        }
    }

    @Override
    public void sell(Player player, int countSell, AbstractShopEntry entry) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Advancement a = serverPlayer.f_8924_.m_129889_().m_136041_(this.advancement);
            if (a != null) {
                for (String s : a.m_138325_().keySet()) {
                    serverPlayer.m_8960_().m_135998_(a, s);
                }
                SDMShopR.addMoney(player, entry.entryPrice);
            }
        }
    }

    @Override
    public int howMany(Player player, boolean isSell, AbstractShopEntry entry) {
        if (player.m_7578_()) {
            if (isSell) {
                if (Minecraft.m_91087_().m_91403_().m_105145_().m_104396_().m_139337_(this.advancement) == null) {
                    return 0;
                }
                return 1;
            }
            if (entry.entryPrice == 0L) {
                return 1;
            }
            if (Minecraft.m_91087_().m_91403_().m_105145_().m_104396_().m_139337_(this.advancement) != null) {
                return 0;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public boolean canExecute(Player player, boolean isSell, int countSell, AbstractShopEntry entry) {
        long needMoney;
        if (isSell) {
            return Minecraft.m_91087_().m_91403_().m_105145_().m_104396_().m_139337_(this.advancement) != null;
        }
        long playerMoney = SDMShopR.getMoney(player);
        return playerMoney >= (needMoney = entry.entryPrice * (long)countSell) && playerMoney - needMoney >= 0L || Minecraft.m_91087_().m_91403_().m_105145_().m_104396_().m_139337_(this.advancement) != null;
    }

    @Override
    public void getConfig(ConfigGroup group) {
        group.add("iconPath", (ConfigValue)new ConfigIconItemStack(), (Object)this.iconPath, v -> {
            this.iconPath = v;
        }, (Object)Items.f_42127_.m_7968_());
        group.addEnum("advancement", (Object)this.advancement, v -> {
            this.advancement = v;
        }, NameMap.of((Object)((ResourceLocation)KnownServerRegistries.client.advancements.keySet().iterator().next()), (Object[])KnownServerRegistries.client.advancements.keySet().toArray(new ResourceLocation[0])).icon(resourceLocation -> ItemIcon.getItemIcon((ItemStack)((KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get((Object)resourceLocation)).icon)).name(resourceLocation -> ((KnownServerRegistries.AdvancementInfo)KnownServerRegistries.client.advancements.get((Object)resourceLocation)).name).create()).setNameKey("ftbquests.reward.ftbquests.advancement");
    }

    @Override
    public Icon getIcon() {
        if (this.iconPath.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.iconPath);
        }
        return ItemIcon.getItemIcon((ItemStack)this.iconPath);
    }

    @Override
    public AbstractShopEntryType copy() {
        return new ShopAdvancementEntryType(this.advancement);
    }

    @Override
    public Icon getCreativeIcon() {
        return ItemIcon.getItemIcon((Item)Items.f_42405_);
    }

    @Override
    public Component getTranslatableForCreativeMenu() {
        return Component.m_237115_((String)"sdm.shop.entry.add.context.advancement");
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        nbt.m_128359_("advancement", this.advancement.toString());
        NBTUtils.putItemStack(nbt, "iconPath", this.iconPath);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.advancement = new ResourceLocation(nbt.m_128461_("advancement"));
        this.iconPath = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("iconPath"));
    }

    @Override
    public String getId() {
        return "advancementType";
    }

    public static class Constructor
    implements IConstructor<AbstractShopEntryType> {
        @Override
        public AbstractShopEntryType createDefaultInstance() {
            return new ShopAdvancementEntryType(new ResourceLocation("minecraft:story/root"));
        }
    }
}

